% Section 5.6.2 Case 2: Output Feedback
% 29/02/2020, Jianglin Lan
close all
clear
clc

% Set up Yalmip & Mosek, this may differ on different computer
% Find installation details in links: 
% https://yalmip.github.io/tutorial/installation/
% https://docs.mosek.com/9.1/toolbox/install-interface.html
addpath(genpath('C:\YALMIP-master'))
addpath('C:\Program Files\Mosek\8\toolbox\r2014a')

% System 
R0 = 1.2; L0 = 0.05; Kv = 0.6; Km = 0.6; J0 = 0.1352; B0 = 0.3;
d_Km = 0.01; d_Kv = 0.01;

A = [   24   12
    4.4379   -2.2189]; 
B = [20; 0]; 
Fa = B; 
D = [0;1]; 
C = eye(2); 
Delta_A = [0 0.01
           0.01  0];

[n,m] = size(B);
[~,q] = size(Fa);
[~,l] = size(D);
[p,~] = size(C);

Cox = [eye(n); zeros(n+q,n)];
Coe = [zeros(n,n+q); eye(n+q)];

% Design observer and controller
Mc = eye(2);
Nc = [0 0.01; 0.01 0];
[Kx,M,G,L,H,betao,gammao] = Observer_controller_design(A,B,Fa,D,C,Mc,Nc)

% Define global variables to store data
global Int_ffa Int_yy1 Int_yy2 Int_ts Int_count Int_tmp Int_hatfa Int_u Int_u0 
global Intn_ts Intn_count Intn_tmp Intn_yy1 Intn_yy2 Intn_u0 Intn_ffa Intn_u

Int_ffa = []; Int_yy1 = []; Int_yy2 = []; Int_ts = []; Int_count = 0; Int_tmp = 0;
Int_hatfa = [];  Int_u = []; Int_u0 = 0; 

Intn_ts = []; Intn_tmp = 0; Intn_count = 0; Intn_yy1 = []; Intn_yy2 = [];
Intn_u0 = 0; Intn_ffa = []; Intn_u = [];

% initial conditon
hat_eta0 = 0;
xi0 = [0;0;0];
x0 = [0.5;0.5];
xx0 = [hat_eta0', xi0',x0'];

% Simulation time span
t0 = 0;
tf = 20;
tspan = [t0 tf];

% Solve differential equation
[Int_tt,Int_yy] = ode45(@(t,xx) FTC_sys_performance(t,xx,A,B,Fa,D,C,Delta_A,Kx,M,G,L,H), tspan,xx0);
Int_x1 = Int_yy(:,5);
Int_x2 = Int_yy(:,6);

[Inn_tt,Inn_yy] = ode45(@(t,xx) Norminal_sys_performance(t,xx,A,B,D,C,Delta_A,Kx,M,G,L,H), tspan,xx0);
Inn_x1 = Inn_yy(:,5);
Inn_x2 = Inn_yy(:,6);

% Draw figures
run('Draw_figures.m');